//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.3

import wesual.Controls 1.0

Item {
    id : tabs

    readonly property int           margins     : 2
    property list<TabItemSorter>    items
    property alias                  count       : repeater.count
    property alias                  spacing     : tabRow.spacing
    property ExclusiveGroup     exclusivegroup  : null
    property int                   elideMode    : Text.ElideRight
    property int                   textOffset   : 0
    property int                   activeIndex  : 0 // default first


    signal indexSelected(var index)

    onActiveIndexChanged : {
        //handle outside setting
        if (tabAtIndex(activeIndex) && !tabAtIndex(activeIndex).active) {
            triggerItemAtIndex(activeIndex);
        }
    }

    function triggerItemAtIndex(index) {
        if (index >= items.length || index < 0)
            return;

        var tab = tabAtIndex(index);
        tab.trigger();
    }

    function tabAtIndex(index) {
        return repeater.itemAt(index);
    }

    height : 35
    width : childrenRect.width

    Rectangle {
        id : bottomSeparator
        height : 1
        width : parent.width
        anchors {
            left  : parent.left
            right : parent.right
            rightMargin : 8
            leftMargin : 8
            bottom : parent.bottom
        }
        color : UI.color(UI.TertiarySeparationLine)
    }

    Row {
        id : tabRow

        spacing : 0
        property int desiredSpacing : 18
        property int maxItemWidth : tabs.width
                                    ? (tabs.width-(tabs.count-1)*desiredSpacing
                                       -tabs.count*2*tabs.margins)/tabs.count
                                    : 50
        onMaxItemWidthChanged : {
            // apply correct tab available text widths
            for (var i = 0; i < repeater.count; i++) {
                var tab = repeater.itemAt(i);
                if (maxItemWidth > 10 && tab.implicitWidth > maxItemWidth) {
                    tab.text.width = maxItemWidth;
                } else if (maxItemWidth <= 10) {
                    tab.text.width = 10;
                } else if (tab.text.width < maxItemWidth
                           || tab.implicitWidth > tab.text.width) {
                    tab.text.width = maxItemWidth;
                }
            }
        }

        height : childrenRect.height
        anchors.left : parent.left

        Repeater {
            id : repeater
            model : items
            delegate : Item {
                id : delegate

                property bool  active       : modelData.checked
                property alias mouse        : mouseArea
                property alias text         : content

                function trigger(){
                    modelData.selected();
                    modelData.checked = true;
                    if(action)
                        action.trigger();

                    tabs.indexSelected(index);
                    tabs.activeIndex = index;
                }

                height : 35
                // +tabRow.desiredSpacing Qt 5.3.2 Bug
                implicitWidth : content.contentWidth + 2*tabs.margins
                                + tabRow.desiredSpacing + tabs.textOffset

                Image {
                    id : sortIndicator

                    width  : 9
                    height : 5
                    //anchors.horizontalCenter : parent.horizontalCenter
                    y : 4
                    x : content.x + (content.implicitWidth / 2) - 4
                    sourceSize {
                        width  : 9
                        height : 5
                    }
                    source : "qrc:/controls/icons/list-sort-indicator.png"
                    visible : delegate.active
                    rotation : modelData.ascending ? 180 : 0
                }
                Text {
                    id : content

                    text  : action.text
                    elide : tabs.elideMode
                    font {
                        pixelSize : 11
                        family : UI.fontFamily(UI.SecondaryFont)
                        weight : UI.fontWeight(UI.SecondaryFont)
                        capitalization : Font.AllUppercase
                    }
                    y : 11
                    x : 9 + tabs.textOffset
                    color : UI.color(UI.SecondaryTextColor)
                }

                MouseArea {
                    id : mouseArea
                    anchors.fill : delegate
                    hoverEnabled : true
                    enabled : action.enabled
                    acceptedButtons : Qt.LeftButton
                    onClicked : trigger();
                }
            } // delegate
        } // repeater
    } // tabRow
}
